/******************************************************
"The Rotating Disk" problem and code are submitted by
Moishe Rosenfeld for the ACM Pacific NW Programming
Contest on 15 November 1997.
-------------------------------------------------------
   CODE WRITTEN IN TURBO C++  (Quick dirty but correct)
-------------------------------------------------------
*******************************************************/
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <string.h>
#include <ctype.h>


const char ifilename[] = "rotation.dat";
const int linesize = 1024;


void process (char *line);
istream& eatWS (istream &s);
void OutputTrack (int *a);
void OutputTrack2 (int *a,int k);
void MoveTrackRight (int *a, int k);
void MoveTrackLeft (int *a, int k);
void Rotate (int *a, int k);
void MoveToLeft (int *a);
void MoveToRight (int *a);
void Move2plus (int *a);
void Move12 (int *a);

main ()
{
	char line[linesize];

	cout << endl << endl;

	ifstream ifile (ifilename);
	while (!ifile.eof()) {
		do {
			ifile.getline(line,linesize);
			istrstream temp (line);
			eatWS(temp);
			if (!temp.eof()) break;
			if (ifile.eof()) return 0;
		} while (1);
		process(line);
	}
	return 0;
}

// *** Tracksize ***
int n;


void process (char *line)
{

	istrstream icount (line);
	istrstream iline (line);

	int i,j,x,inversions;

	for (n=0;;n++) {
		icount >> x;
		if (icount.eof() || icount.bad()) break;
	}

	int *a = new int [n];
	for (i=0; i<n; i++) iline >> a[i];

	cout << "Input Track:  ";
	OutputTrack(a);
	cout << "Output: " << endl;
	OutputTrack(a);
	cout << endl;

	for (i=0,inversions=0; i<n-1; i++) {
		for (j=i+1; j<n; j++) {
			if (a[i]>a[j]) inversions++;
		}
	}
	if (n&1 && inversions&1) {
		cout << "No solution." << endl << endl;
		return;
	}


	for (i=0; i<n && a[i]!=n; i++);
	MoveTrackRight(a,n-i-1);
	OutputTrack(a);

	for (x=1; x<=n-4; x++) {
		for (i=0; i<n && a[i]!=x; i++);
		while (i>3) {
			Rotate(a,i-3);
			i -= 3;
		}
		switch (i) {
			case 1: Rotate(a,0);
			case 2: Rotate(a,1);
			case 3: Rotate(a,0);
			case 0: break;
		}
		MoveTrackLeft(a,1);
	}
	OutputTrack(a);


	for (i=0,inversions=0; i<3; i++) {
		for (j=i+1; j<n; j++) {
			if (a[i]>a[j]) inversions++;
		}
	}
	if (inversions&1) {
		MoveTrackLeft(a,3);
		for (i=0; i<n/4; i++) {
			MoveToRight(a);
			MoveTrackLeft(a,4);
		}
		if (a[0]==n) MoveTrackRight(a,2);
		else MoveTrackRight(a,4);
	}
	OutputTrack(a);

	do {
		for (i=0,x=0,j=1000; i<4; i++,j/=10) x+=((a[i]-(n-4))*j);
		switch (x) {
			case 1234: break;
			case 1342: Move2plus(a);
			case 3124: Move12(a); break;
			case 4132: Move2plus(a);
			case 1423: Move12(a);
			case 2143: Move2plus(a); break;
			default: Rotate(a,0); break;
		}
	} while (x!=1234);
	MoveTrackLeft(a,4);
	OutputTrack(a);
	cout << endl;

	delete a;
	return;
}


istream& eatWS (istream &s)
{
	char c;
	if (s.eof()) return s;

	do {
		s.get(c);
	} while (isspace(c) && !s.eof());
	if (!s.eof()) s.putback(c);
	return s;
}


void OutputTrack (int *a)
{
	for (int i=0; i<n; i++,a++) {
		cout << *a << ' ';
	}
	cout << endl;
	return;
}
void OutputTrack2 (int *a,int k)
{  int i;
	for (i=0; i<n; i++,a++) {
		if (i==k || i==k+4) cout << "* ";
		cout << *a << ' ';
	}
	if (i==k+4) cout << '*';
	cout << endl;
	return;
}


void MoveTrackRight (int *a, int k)
{
	int *b = new int [k];
	memmove(b,a+n-k,k*sizeof(int));
	memmove(a+k,a,(n-k)*sizeof(int));
	memmove(a,b,k*sizeof(int));
	delete b;
	return;
}
void MoveTrackLeft (int *a, int k)
{
	int *b = new int [k];
	memmove(b,a,k*sizeof(int));
	memmove(a,a+k,(n-k)*sizeof(int));
	memmove(a+n-k,b,k*sizeof(int));
	delete b;
	return;
}

void Rotate (int *a, int k)
{
	int b;
	b = a[k];
	a[k] = a[k+3];
	a[k+3] = b;
	b = a[k+1];
	a[k+1] = a[k+2];
	a[k+2] = b;
	OutputTrack2(a,k);
	return;
}

void MoveToLeft (int *a)
{
	Rotate(a,1);
	Rotate(a,0);
	Rotate(a,1);
	Rotate(a,0);
	return;
}

void MoveToRight (int *a)
{
	Rotate(a,0);
	Rotate(a,1);
	Rotate(a,0);
	Rotate(a,1);
	return;
}

void Move2plus (int *a)
{
	Rotate(a,2);
	Rotate(a,0);
	MoveTrackLeft(a,1);
	MoveToRight(a);
	MoveTrackRight(a,1);
	MoveToRight(a);
	return;
}

void Move12 (int *a)
{
	Rotate(a,1);
	Rotate(a,2);
	Rotate(a,1);
	Rotate(a,0);
	Rotate(a,2);
	Rotate(a,1);
	Rotate(a,2);
	Rotate(a,0);
	Rotate(a,1);
	Rotate(a,2);
	Rotate(a,0);
	Rotate(a,1);
	return;
}




